<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once __DIR__ . '/stripe/init.php';

// Zet je geheime API key (test of live)
\Stripe\Stripe::setApiKey('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'); // <-- vervang met jouw echte SECRET key

header('Content-Type: application/json');

// Ontvang gekozen pakket van JavaScript
$data = json_decode(file_get_contents('php://input'), true);
$pakket = $data['pakket'] ?? 'klein';

// Definieer pakketten en prijzen in centen
$pakketten = [
    'klein' => ['naam' => 'Klein proefpakket', 'prijs' => 1495],
    'normaal' => ['naam' => 'Normaal proefpakket', 'prijs' => 1995],
    'groot' => ['naam' => 'Groot proefpakket', 'prijs' => 3495],
    'slim' => ['naam' => 'Grote wasser – Slim inkopen', 'prijs' => 5995],
];

if (!isset($pakketten[$pakket])) {
    http_response_code(400);
    echo json_encode(['error' => 'Ongeldig pakket']);
    exit;
}

// Vervang door jouw eigen domein of localhost URL
$YOUR_DOMAIN = 'https://bio-suds.nl/winkel';

try {
$checkout_session = \Stripe\Checkout\Session::create([
        'payment_method_types' => [
            'card',         // Creditcard + Apple Pay / Google Pay
            'ideal',        // iDEAL
            'bancontact',   // Bancontact (België)
            'klarna',       // Klarna achteraf betalen
        ],
        'mode' => 'payment',
    'locale' => 'nl', // 🇳🇱 Forceer Nederlandse taal
  
  // 🔹 Adresgegevens verplicht maken
  'billing_address_collection' => 'required',
  'shipping_address_collection' => [
      'allowed_countries' => ['NL', 'BE'], // alleen NL en BE toestaan
  ],

  // 🔹 Productinformatie
  'line_items' => [[
    'price_data' => [
      'currency' => 'eur',
      'product_data' => [
        'name' => $pakketten[$pakket]['naam'],
        'description' => 'Milieuvriendelijk proefpakket van Bio-Suds – duurzaam wassen & afwassen.',
        'images' => [
          'https://www.bio-suds.com/cdn/shop/files/bio_suds_vaatwas.png?v=1734464722&width=600'
        ],
      ],
      'unit_amount' => $pakketten[$pakket]['prijs'],
    ],
    'quantity' => 1,
  ]],

  // 🔹 Succes/cancel URLs
  'success_url' => $YOUR_DOMAIN . '/success.php?session_id={CHECKOUT_SESSION_ID}',
  'cancel_url' => $YOUR_DOMAIN . '/index.php',
]);


    echo json_encode(['id' => $checkout_session->id]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => $e->getMessage()]);
}
