<?php
require('fpdf/fpdf.php');
date_default_timezone_set('Europe/Amsterdam');

// Projectnaam uit de URL
$project = $_GET['project'] ?? '';
$filename = 'logs/' . preg_replace('/[^a-zA-Z0-9_-]/', '_', $project) . '.json';

if (!$project || !file_exists($filename)) {
    die("Geen log gevonden voor dit project.");
}

$data = json_decode(file_get_contents($filename), true);

// PDF genereren
class PDF extends FPDF {
    function Header() {
        global $project;
        $this->SetFont('Arial','B',14);
        $this->Cell(0,10,"Tijdregistratie - $project",0,1,'C');
        $this->Ln(5);
    }

    function Footer() {
        $this->SetY(-15);
        $this->SetFont('Arial','I',8);
        $this->Cell(0,10,'Pagina '.$this->PageNo(),0,0,'C');
    }
}

$pdf = new PDF();
$pdf->AddPage();
$pdf->SetFont('Arial','',11);

foreach ($data as $entry) {
    $pdf->Cell(0, 8, "Van: " . $entry['start'] . "  Tot: " . $entry['end'], 0, 1);
    $pdf->Cell(0, 8, "Duur: " . $entry['duration_minutes'] . " minuten", 0, 1);
    $pdf->MultiCell(0, 8, "Activiteit: " . $entry['description']);
    $pdf->Ln(5);
}

$pdf->Output('D', "rapport_$project.pdf");
exit;
