<?php
session_start();
date_default_timezone_set('Europe/Amsterdam');

if (!isset($_GET['project'], $_GET['index'])) {
    die("Geen log geselecteerd.");
}

$project = preg_replace('/[^a-zA-Z0-9_-]/', '_', $_GET['project']);
$index = (int)$_GET['index'];
$filename = "logs/$project.json";

if (!file_exists($filename)) die("Logbestand niet gevonden.");
$data = json_decode(file_get_contents($filename), true);
if (!isset($data[$index])) die("Logregel bestaat niet.");

$entry = $data[$index];
$success = false;
$deleted = false;
$fout = false;

// 🗑 Verwijderen
if (isset($_POST['verwijder'])) {
    unset($data[$index]);
    $data = array_values($data); // herindexeren
    file_put_contents($filename, json_encode($data, JSON_PRETTY_PRINT));
    $deleted = true;
}
// ✅ Bewerken
elseif ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['opslaan'])) {
    $start = $_POST['start'] ?? '';
    $end = $_POST['end'] ?? '';
    $desc = trim($_POST['description'] ?? '');
    $newProject = preg_replace('/[^a-zA-Z0-9_-]/', '_', $_POST['new_project'] ?? $project);

    $startDT = DateTime::createFromFormat('Y-m-d\TH:i', $start);
    $endDT = DateTime::createFromFormat('Y-m-d\TH:i', $end);

    if ($startDT && $endDT && $endDT > $startDT && $desc) {
        $entry['start'] = $startDT->format('Y-m-d H:i:s');
        $entry['end'] = $endDT->format('Y-m-d H:i:s');
        $entry['duration_minutes'] = round(($endDT->getTimestamp() - $startDT->getTimestamp()) / 60);
        $entry['description'] = $desc;

        unset($data[$index]); // haal uit oud project

        if ($newProject === $project) {
            $data[] = $entry;
            file_put_contents($filename, json_encode(array_values($data), JSON_PRETTY_PRINT));
        } else {
            // verplaatsen naar ander project
            $newFile = "logs/$newProject.json";
            $newData = file_exists($newFile) ? json_decode(file_get_contents($newFile), true) : [];
            $newData[] = $entry;
            file_put_contents($newFile, json_encode($newData, JSON_PRETTY_PRINT));
            file_put_contents($filename, json_encode(array_values($data), JSON_PRETTY_PRINT));
        }
        $success = true;
    } else {
        $fout = true;
    }
}

// helper voor datetime-local
function toDatetimeLocal($str) {
    $dt = DateTime::createFromFormat('Y-m-d H:i:s', $str);
    return $dt ? $dt->format('Y-m-d\TH:i') : '';
}
?>

<!DOCTYPE html>
<html lang="nl">
<head>
    <meta charset="UTF-8">
    <title>Bewerk log</title>
    <link rel="stylesheet" href="assets/style.css">
</head>
<body>

<?php include 'includes/menu.php'; ?>

<h2>✏️ Logregel bewerken</h2>

<?php if ($deleted): ?>
    <p>🗑 Logregel verwijderd.</p>
    <p><a href="overzicht.php">⬅️ Terug naar overzicht</a></p>

<?php elseif ($success): ?>
    <p>✅ Logregel succesvol aangepast.</p>
    <p><a href="overzicht.php">⬅️ Terug naar overzicht</a></p>

<?php else: ?>
    <?php if ($fout): ?>
        <p style="color:red;">⚠️ Vul alle velden correct in.</p>
    <?php endif; ?>

    <form method="post">
        <label for="start">Starttijd:</label>
        <input type="datetime-local" name="start" id="start" value="<?= toDatetimeLocal($entry['start']) ?>" required><br><br>

        <label for="end">Eindtijd:</label>
        <input type="datetime-local" name="end" id="end" value="<?= toDatetimeLocal($entry['end']) ?>" required><br><br>

        <label for="new_project">Project:</label>
        <input type="text" name="new_project" id="new_project" value="<?= htmlspecialchars($_GET['project']) ?>" required><br><br>

        <label for="description">Beschrijving:</label><br>
        <textarea name="description" rows="5" required><?= htmlspecialchars($entry['description']) ?></textarea><br><br>

        <button type="submit" name="opslaan">Opslaan</button>
        <button type="submit" name="verwijder" style="margin-left: 15px; background-color: crimson;">Verwijderen</button>
    </form>
<?php endif; ?>

</body>
</html>
