<?php
/**
 * Account Widget View
 *
 * This is rendered on the WordPress dashboard Bluehost Account widget.
 * Icon svgs from HeroIcons https://heroicons.com/
 *
 * @package WPPluginBluehost
 */

namespace Bluehost;

// lifebuoy icon - in widget handle
$svg    = '<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-6"><path stroke-linecap="round" stroke-linejoin="round" d="M16.712 4.33a9.027 9.027 0 0 1 1.652 1.306c.51.51.944 1.064 1.306 1.652M16.712 4.33l-3.448 4.138m3.448-4.138a9.014 9.014 0 0 0-9.424 0M19.67 7.288l-4.138 3.448m4.138-3.448a9.014 9.014 0 0 1 0 9.424m-4.138-5.976a3.736 3.736 0 0 0-.88-1.388 3.737 3.737 0 0 0-1.388-.88m2.268 2.268a3.765 3.765 0 0 1 0 2.528m-2.268-4.796a3.765 3.765 0 0 0-2.528 0m4.796 4.796c-.181.506-.475.982-.88 1.388a3.736 3.736 0 0 1-1.388.88m2.268-2.268 4.138 3.448m0 0a9.027 9.027 0 0 1-1.306 1.652c-.51.51-1.064.944-1.652 1.306m0 0-3.448-4.138m3.448 4.138a9.014 9.014 0 0 1-9.424 0m5.976-4.138a3.765 3.765 0 0 1-2.528 0m0 0a3.736 3.736 0 0 1-1.388-.88 3.737 3.737 0 0 1-.88-1.388m2.268 2.268L7.288 19.67m0 0a9.024 9.024 0 0 1-1.652-1.306 9.027 9.027 0 0 1-1.306-1.652m0 0 4.138-3.448M4.33 16.712a9.014 9.014 0 0 1 0-9.424m4.138 5.976a3.765 3.765 0 0 1 0-2.528m0 0c.181-.506.475-.982.88-1.388a3.736 3.736 0 0 1 1.388-.88m-2.268 2.268L4.33 7.288m6.406 1.18L7.288 4.33m0 0a9.024 9.024 0 0 0-1.652 1.306A9.025 9.025 0 0 0 4.33 7.288" /></svg>';
$svg_64 = base64_encode( $svg );

// help illustration svg
$help_svg = '<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 20 159 153">
  <path fill="#fff" stroke="#03243B" stroke-miterlimit="10" stroke-width=".7" d="M65.2 69.8c4.4-19 2.5-25.2-.3-27.3-1.2-.9-2.8-1.2-5-3.4-3-2.8-3.4-5-5.5-8.2-3-4.2-8.2-8.8-10.7-7.4-2.4 1.3-2.2 8.8 0 14.4 2.6 7 6.7 7.4 7.6 13.2.8 5.2-2 7-.9 10.7 1 2.9 4.1 6.3 14.8 8Z"/>
  <path fill="#03243B" d="m65 66.6-.2-.2A71.7 71.7 0 0 0 48.5 34l.1-.1h.2s2.6 2.5 6 7.7a89.4 89.4 0 0 1 10.3 25Z"/>
  <path fill="#fff" stroke="#03243B" stroke-miterlimit="10" stroke-width=".7" d="M52.3 65c-2-13-4.8-16.3-7-16.8-1-.2-2 0-4-.6-2.6-.9-3.3-2.2-5.5-3.5-2.8-1.8-7.2-3-8.4-1.5-1.2 1.6.8 6.1 3.6 9 3.3 3.5 6 2.6 8 6 1.8 3 .5 5 2.1 6.8 1.3 1.6 4.1 2.8 11.2.7Z"/>
  <path fill="#03243B" d="M51.3 63.2h-.1C41.9 51 33 48 33 48l-.1-.2a.3.3 0 0 1 0-.1v-.1a.2.2 0 0 1 .2-.1c.1 0 9 3 18.4 15.3a.3.3 0 0 1 0 .3l-.2.1Z"/>
  <path fill="#66A8F7" d="M115.8 58.6h-81c-2.6 0-5 2.3-5.2 5L23.4 130c-.3 2.8 1.6 5 4.1 5h81.1c2.6 0 4.9-2.2 5.1-5l6.3-66.4c.3-2.7-1.6-5-4.2-5Z"/>
  <path fill="#03243B" d="M108.6 135.3h-81a4 4 0 0 1-1.9-.4l-1.5-1.2a5.2 5.2 0 0 1-1-3.8l6.2-66.3c.3-2.9 2.7-5.3 5.3-5.3h81.1c.7 0 1.3.2 1.8.4a4.4 4.4 0 0 1 2.5 3c.2.6.2 1.3.1 2L114 130c-.3 3-2.7 5.3-5.4 5.3ZM34.7 58.8c-2.4 0-4.6 2.2-4.9 4.9L23.6 130a4.6 4.6 0 0 0 1 3.4c.3.4.8.8 1.3 1 .5.3 1 .4 1.6.4h81.1c2.5 0 4.7-2.2 5-4.9l6.2-66.3a4.6 4.6 0 0 0-1-3.4 4 4 0 0 0-1.3-1c-.6-.3-1.1-.4-1.7-.4h-81Z"/>
  <path fill="#fff" d="M109.5 131.4H27.3l.3-3.7H110l-.4 3.7Z"/>
  <path fill="#03243B" d="M110.2 124.4h-23l1.1-11.7h23l-1.1 11.7Zm1.3-14.2h-23l1.2-11.8h23l-1.2 11.8Zm1.4-14.2h-23L91 84h23l-1.1 12Zm1.3-14.3h-23l1.2-11.8h23l-1.2 11.8ZM72 116.5c10.2-10.4 11.3-26.9 2.7-36.8-8.7-9.9-23.8-9.4-33.9 1-10 10.4-11.2 26.8-2.6 36.7 8.6 10 23.8 9.5 33.9-.9ZM115.6 67H33.2v-.3l.2-.1h82.4v.4h-.2Zm-79-3-.3.6-.5.2h-.3l-.3-.2-.1-.3V64c0-.3 0-.5.2-.6l.6-.3h.3l.2.3.2.2v.4Zm3.1 0-.3.6-.6.2h-.3l-.2-.2-.1-.3V64c0-.3 0-.5.2-.6l.6-.3h.3l.2.3.2.2v.4Zm3.1 0-.3.6-.6.2h-.3l-.2-.2-.1-.3V64c0-.3 0-.5.2-.6l.6-.3h.3l.2.3.1.2v.4Zm73.2.2H64.7v-.4H116l.1.2v.1l-.2.1Zm-53 0H53v-.4h10.2v.3l-.2.1Zm-14.5 0h-4.1V64a.3.3 0 0 1 0-.3h4.2a.3.3 0 0 1 0 .3v.1h-.1Z"/>
  <path fill="#fff" d="M144.2 23.7H109c-.9 0-1.7.4-2.4 1-.7.7-1 1.6-1.2 2.6l-6.2 66.4a3.4 3.4 0 0 0 .7 2.5c.2.4.6.6 1 .8.3.2.7.3 1.2.3h35.3c.9 0 1.7-.4 2.4-1 .7-.7 1-1.6 1.2-2.6l6.2-66.4a3.4 3.4 0 0 0-.7-2.5c-.2-.4-.6-.6-1-.8-.3-.2-.8-.3-1.2-.3Z"/>
  <path fill="#03243B" d="M137.3 97.5H102c-.5 0-1 0-1.3-.3-.4-.2-.8-.4-1.1-.8l-.7-1.3v-1.4l6.2-66.5c.1-1 .6-2 1.2-2.6a4 4 0 0 1 2.6-1.1h35.3c.5 0 1 0 1.3.3.4.2.8.5 1 .8.4.4.6.8.7 1.3.2.4.2 1 .2 1.4L141 93.8a4 4 0 0 1-1.3 2.6 4 4 0 0 1-2.5 1.1ZM108.9 24c-.8 0-1.6.4-2.3 1-.6.6-1 1.4-1 2.3l-6.3 66.5a3.2 3.2 0 0 0 .6 2.3l1 .7 1 .2h35.4c.8 0 1.6-.3 2.2-1a4 4 0 0 0 1.2-2.3l6.2-66.5a3.2 3.2 0 0 0-.6-2.3l-1-.7-1-.2h-35.4Z"/>
  <path fill="#03243B" d="M144.3 29.6h-36.8v-.4h37v.4h-.2ZM110 27.4c0 .2-.2.3-.3.4l-.4.2a.4.4 0 0 1-.3-.2l-.1-.2v-.2c0-.2 0-.3.2-.4l.4-.2h.2l.1.2a.5.5 0 0 1 .1.4Zm2 0-.1.4-.4.2h-.2l-.2-.2v-.2l-.1-.2c0-.1 0-.3.2-.4l.4-.2h.2l.2.2v.4Zm2.2 0c0 .2 0 .3-.2.4l-.4.2h-.2l-.1-.2a.5.5 0 0 1-.2-.4l.2-.4.4-.2h.2l.2.2.1.2v.2Zm30.3.3h-15v-.1a.3.3 0 0 1-.1-.3.2.2 0 0 1 .2-.1h15a.2.2 0 0 1 .1 0v.2a.3.3 0 0 1 0 .2h-.2Zm-16.3 0h-6.8l-.1-.1a.3.3 0 0 1 0-.4h7a.2.2 0 0 1 .2.1.3.3 0 0 1 0 .2l-.2.1Zm-10 0h-2.7l-.2-.1v-.4h3v.4h-.1Zm-2.5 15.5c1.8-1.8 2-4.7.4-6.4-1.5-1.8-4.2-1.7-6 .1-1.7 1.9-2 4.8-.4 6.5 1.5 1.8 4.2 1.7 6-.2Z"/>
  <path fill="#66A8F7" d="M127.8 43.2c1.8-1.8 2-4.7.4-6.4-1.5-1.8-4.2-1.7-6 .1-1.7 1.9-2 4.8-.4 6.5 1.5 1.8 4.2 1.7 6-.2Zm12.1 0c1.8-1.8 2-4.7.4-6.4-1.5-1.8-4.2-1.7-6 .1-1.7 1.9-2 4.8-.4 6.5 1.5 1.8 4.2 1.7 6-.2Zm-1.3 24.4h-32.4l1.9-20h32.4l-1.9 20Zm-2.2 23.8H104l1.8-20h32.5l-1.9 20Z"/>
  <path fill="#fff" d="M126 120.8H83c-.7 0-1.4.3-1.9.8s-.8 1.2-1 1.9l-2.8 30.7a2.6 2.6 0 0 0 .6 2l.7.6 1 .2h43c.6 0 1.3-.3 1.8-.8s.8-1.2.9-2l2.9-30.7a2.6 2.6 0 0 0-.6-2l-.7-.5a2 2 0 0 0-1-.2Z"/>
  <path fill="#03243B" d="M122.5 157.2h-43c-.3 0-.6 0-1-.2l-.8-.7-.5-1c-.1-.3-.2-.7-.1-1l2.9-30.8c0-.8.4-1.6 1-2.1a3 3 0 0 1 2-.9h43c.3 0 .6 0 1 .2l.8.7.5 1 .1 1.1-2.9 30.8c0 .8-.4 1.5-1 2a3 3 0 0 1-2 1ZM83 121c-.7 0-1.3.3-1.7.7a3 3 0 0 0-.9 1.8l-2.9 30.8a2.4 2.4 0 0 0 .5 1.7l.7.5c.3.2.6.2.9.2h43c.5 0 1.2-.3 1.6-.7.5-.5.8-1.1.9-1.8l2.9-30.7a2.4 2.4 0 0 0-.5-1.8 2 2 0 0 0-.7-.5l-.9-.2H83Z"/>
  <path fill="#03243B" d="M123.1 125.5H83.8a.3.3 0 0 1 0-.4h39.4l.1.2v.1l-.2.1Zm-38.4-2.6c0 .2 0 .3-.2.5l-.5.2h-.2l-.2-.2-.1-.3v-.2c0-.2 0-.4.2-.5.1-.2.3-.2.5-.2a.5.5 0 0 1 .4.2l.1.2v.3Zm2.6 0c0 .2 0 .3-.2.5l-.5.2h-.2l-.2-.2-.1-.3v-.2c0-.2 0-.4.2-.5.1-.2.3-.2.4-.2a.5.5 0 0 1 .5.2l.1.2v.3Zm2.6 0-.2.5-.5.2H89l-.2-.2-.2-.3v-.2l.2-.5c.2-.2.3-.2.5-.2a.5.5 0 0 1 .5.2v.2l.1.3Zm34.1.2H98.5l-.1-.2v-.2h25.9v.3l-.2.1Zm-29.3 0h-3.4v-.4h3.5v.3l-.1.1Z"/>
  <path fill="#66A8F7" d="M122.4 145.8h-41l1.6-17.9h41l-1.6 17.9Z"/>
  <path fill="#03243B" d="M97.3 150.8H80.8l.3-3h16.4l-.2 3Z"/>
  <path fill="#fff" d="M102.8 54s4.4-8.1 7.9-10.8c3.5-2.7-.6 1.7-1.1 2.6-.6 1 .5 1.8.5 3.9 0 2-1.1 1.5-2.5 2.2-1.3.7-2.5 3.9-2.5 3.9l-2.3-1.9Z"/>
  <path fill="#03243B" d="M105.1 56h-.1l-2.3-1.9-.1-.1v-.2c.2-.3 4.5-8.1 8-10.8 1.2-1 1.5-1 1.6-.8.3.3 0 .6-1.5 2.5l-1 1.3c-.2.3 0 .7.2 1.3.3.8.4 1.6.5 2.4 0 1.6-.8 1.8-1.7 2l-1 .4c-1.2.7-2.3 3.7-2.4 3.8l-.2.1Zm-2-2.1 2 1.5c.3-.8 1.3-3.1 2.5-3.7a6 6 0 0 1 1-.4c.9-.2 1.3-.3 1.3-1.6 0-.8-.2-1.5-.4-2.2-.3-.7-.5-1.2-.1-1.8a35 35 0 0 0 2.2-2.9l-.8.6c-3.1 2.4-7 9.2-7.7 10.4Z"/>
  <path fill="#fff" d="m102.9 52.4 3.3 3.4S100 77 81.2 84.6c-5.6 4.8-11.7 5.6-14 42.4 0 0-30.7 10.8-33.8-4.5 0 0 5-19.3 15.5-34.3 3.5-5 9-11.7 14-11.2 5 .6 30.3-2.8 40-24.6Z"/>
  <path fill="#03243B" d="M47.3 131c-4.2 0-7.5-.8-10-2.3a9.1 9.1 0 0 1-4.2-6.2c0-.2 5.2-19.6 15.7-34.5C54.3 80.1 59 76.3 63 76.8c2.3.2 9.8-.4 18-4a40.6 40.6 0 0 0 22-20.6l3.4 3.4a.3.3 0 0 1 0 .3s-1.6 5.4-5.4 11.6a43 43 0 0 1-19.6 17.3l-1.7 1.4a19 19 0 0 0-7.3 9.5 114.3 114.3 0 0 0-5.2 31.6 79.6 79.6 0 0 1-20 3.7Zm-13.7-8.5a8.7 8.7 0 0 0 4 5.8c8.6 5.4 27.5-.8 29.3-1.4A114 114 0 0 1 72 95.5a19 19 0 0 1 7.5-9.7l1.7-1.4c9.6-4 15.9-11.5 19.4-17.2 3.5-5.6 5-10.4 5.4-11.3l-3-3a41.2 41.2 0 0 1-21.8 20.4 44 44 0 0 1-18.3 4c-3.7-.5-8.3 3.3-13.8 11a122 122 0 0 0-15.5 34.2Z"/>
  <path fill="#fff" d="m86.1 91.5 2.5-5.4c.2-.6.6-1.1 1.1-1.5.4-.3.8-.5 1.3-.5l2.9-.3s3.3-3.1 4.5-3L95.2 86a2 2 0 0 1-.9.9c-.3.2-.7.4-1 .4l-1.7.3c-.2 0-.4 0-.5.2l-.4.6-1.7 5-2.9-1.9Z"/>
  <path fill="#03243B" d="M89 93.6h-.1l-2.9-2-.1-.1v-.2l2.5-5.4c.2-.6.7-1.2 1.2-1.6.4-.3.9-.5 1.4-.6l2.8-.3c.5-.5 3.4-3 4.6-3h.1l.1.2a.3.3 0 0 1 0 .2L95.4 86c-.3.4-.6.8-1 1l-1.1.5-1.7.2c-.1 0-.3 0-.4.2a1 1 0 0 0-.3.4l-1.7 5v.1a.2.2 0 0 1-.2 0Zm-2.6-2.2L89 93l1.6-4.7c0-.3.2-.5.4-.7l.7-.3 1.6-.2c.4 0 .7-.2 1-.4l.8-.8 3-4.8a17.1 17.1 0 0 0-4 2.9l-3 .3a2 2 0 0 0-1.2.5c-.4.4-.8.9-1 1.4l-2.4 5.2Z"/>
  <path fill="#fff" d="m91.3 84.6 2.6-.2c0 .2-.1.3-.3.5l-.4.3-2.4 1.3.5-1.9Z"/>
  <path fill="#03243B" d="M90.8 86.7h-.1l-.1-.2v-.1l.1-.1 2.4-1.3.4-.3-2.1.2h-.2v-.4l.1-.1L94 84l.2.1v.2l-.3.6-.5.4-2.4 1.3Z"/>
  <path fill="#fff" d="m86.9 88.8 4 2.5s-3 17-19 16.7c-15.9-.2-20.7-12.9-20.7-12.9l8.3-9.2s14.4 19.4 27.4 2.9Z"/>
  <path fill="#03243B" d="M72.3 108.3H72a23.2 23.2 0 0 1-16.6-6.6 20.3 20.3 0 0 1-4.4-6.6v-.2h.3v.2s1.3 3.1 4.4 6.3c3 2.8 8.1 6.3 16.3 6.4a17 17 0 0 0 15.2-8.2c1.6-2.5 2.7-5.3 3.4-8.2L86.9 89c-9.2 11.5-19 5.5-24 .8l-.1-.1v-.2l.2-.1h.1c5 4.6 14.6 10.5 23.6-.9h.2l4 2.5h.1v.2c-.6 3-1.8 6-3.5 8.6a17.5 17.5 0 0 1-15.2 8.4Z"/>
  <path fill="#fff" d="M66.6 66.7s-1.4 6.2-5.2 10.4c1.8 2 4.3 3.2 6.8 3.4 4.4.3 1-4 1-4l1.9-7.4-4.5-2.4Z"/>
  <path fill="#03243B" d="M68.7 80.7h-.5a11 11 0 0 1-7-3.4V77a27.2 27.2 0 0 0 5.3-10.5.2.2 0 0 1 .2 0l4.5 2.4c.1.1.1.2 0 .2l-1.8 7.4c.4.5 1.7 2.3 1.2 3.4-.3.6-1 .8-2 .8Zm-7-3.6c1.8 1.9 4.1 3 6.6 3.1.7 0 1.6 0 1.9-.5.3-.8-.8-2.4-1.2-3v-.2l1.8-7.3-4-2.1c-.4 1.2-1.9 6.3-5 10Z"/>
  <path fill="#fff" d="M73 63.7c.2.6 0 1.2-.5 1.4-.4.2-1-.2-1.1-.8-.3-.6 0-1.3.4-1.4.4-.2 1 .1 1.2.8Z"/>
  <path fill="#03243B" d="M72.3 65.4a1 1 0 0 1-.6-.2c-.2-.2-.5-.5-.6-.8-.2-.8 0-1.5.6-1.8a1 1 0 0 1 .9.2c.3.2.5.4.6.8.2.7 0 1.5-.6 1.7h-.3ZM72 63c-.4.1-.5.6-.3 1.1 0 .2.2.4.4.6h.4c.4 0 .5-.6.3-1a1 1 0 0 0-.3-.6.6.6 0 0 0-.4-.1Z"/>
  <path fill="#03243B" d="M69.9 57.2c-2.2.3-2.5 2.9-5 3.1-1.2.2-1.8-.3-2.8.2-.7.4-1.7 1.2-1.8 2.3-.2 1.5 1.3 1.8 2.7 4.6 1 2 1.1 3.3 2 3.5.8.1 1.2-1.1 2.1-1 1.2 0 1.3 2.3 2.6 3 .9.4 2.8.3 5.6-2.1l-1.4-2.9c-1.8-3.3-3.1-3.9-2.8-4.9.4-1.5 3-1.2 3.2-2.5.2-1.2-2.3-3.6-4.4-3.3Z"/>
  <path fill="#fff" d="m66.3 63.8 1 .5s1.4 3.4 2 4.5c.8 1 4-1 4-1l.1-.8.4-.8a.5.5 0 0 0-.1-.6 14 14 0 0 1-3-4.3 5.4 5.4 0 0 0-4.4 2.5Z"/>
  <path fill="#03243B" d="m66.5 63.8.9.3v.1a110.3 110.3 0 0 0 2 4.3l.2.1v.1l.2.1h.4c.4 0 .7 0 1-.2a12 12 0 0 0 2-1l-.1.1.1-.7a8.3 8.3 0 0 0 .5-1l-.1-.1-.2-.2-1-1.3a9.7 9.7 0 0 1-1.9-2.9l.2.2a4.2 4.2 0 0 0-1.2.1 4.7 4.7 0 0 0-2.2 1.3 4.8 4.8 0 0 0-.6.6l-.2.2Zm-.4.1a3.8 3.8 0 0 1 .4-.8 5.5 5.5 0 0 1 2.9-1.9h.6l.7-.1h.1l.1.1a11.2 11.2 0 0 0 1.7 2.9l1 1.2.2.2a.7.7 0 0 1 .2.5.7.7 0 0 1-.1.3l-.3.8v.7h-.2c-.6.5-1.3.9-2 1.2l-1.1.3-.7-.1a1 1 0 0 1-.3-.2h-.1l-.1-.2a24 24 0 0 1-2-4.4v.2l-1-.7Z"/>
  <path fill="#fff" d="M67.5 67s-1.5-2-2.2-1.2c-.7 1 1 3.1 2.2 1.1Z"/>
  <path fill="#03243B" d="M66.4 68h-.1c-.3 0-.6-.1-.8-.3L65 67a1.4 1.4 0 0 1 .1-1.4l.3-.2.4-.1c.9 0 1.8 1.3 2 1.4a.3.3 0 0 1 0 .4c-.5.8-1 1-1.4 1Zm-.6-2h-.2a.7.7 0 0 0 0 .7l.2.5.5.2.5-.1.3-.4c-.4-.4-1-1-1.3-1Z"/>
  <path fill="#fff" d="M71.7 64.1c.2.7 0 1.3-.4 1.5-.4.1-1-.2-1.2-.8-.2-.6 0-1.3.5-1.4.4-.2 1 .1 1.1.7Z"/>
  <path fill="#03243B" d="m71 65.9-.6-.3c-.3-.2-.4-.5-.5-.7-.2-.8 0-1.6.6-1.8.5-.2 1.2.2 1.5 1 .2.7 0 1.5-.6 1.7H71Zm-.2-2.3h-.2c-.3.1-.4.6-.3 1 .2.6.6.9 1 .7.3 0 .4-.6.2-1a1 1 0 0 0-.2-.5.8.8 0 0 0-.5-.2Z"/>
  <path fill="#03243B" d="m66.8 66-.1-.1-.1-.2v-.1l.1-.2 3.3-1.2a.2.2 0 0 1 .2 0 .3.3 0 0 1 0 .2.3.3 0 0 1 0 .2L66.8 66Zm50 69.3h-.1v-.2a.3.3 0 0 1 0-.2 52.8 52.8 0 0 0 16.2-35.1 63 63 0 0 0-1.1-19h.2v.1a63.7 63.7 0 0 1-2.7 36.5 50.4 50.4 0 0 1-12.5 17.9Zm16.5-19.7a.2.2 0 0 1-.2-.3 50.5 50.5 0 0 0 3.2-21.5.2.2 0 0 1 .2.1.2.2 0 0 1 0 .2c0 .1 1 13.7-3 21.4h-.2ZM35 140.5a.2.2 0 0 1-.2 0l-.6-.8a.3.3 0 0 1 0-.3h.3l.7.7v.4H35Zm2.3 2.5a.2.2 0 0 1-.2 0l-.6-.7v-.1a.3.3 0 0 1 0-.2.2.2 0 0 1 0-.1.2.2 0 0 1 .3 0l.7.7v.4h-.2Zm-3 0-.2-.1v-.2l.7-.8h.1a.2.2 0 0 1 .3 0 .3.3 0 0 1 0 .3l-.7.8h-.2Zm2.4-2.5a.2.2 0 0 1-.2 0v-.4l.7-.7a.2.2 0 0 1 .1 0 .2.2 0 0 1 .2 0 .2.2 0 0 1 0 .2v.1l-.7.8a.2.2 0 0 1-.1 0Zm77.3-1.9-.9-.3c-.3-.2-.5-.5-.6-.8a1.9 1.9 0 0 1 .4-1.9c.2-.2.5-.4.8-.4h.9l.7.7a1.8 1.8 0 0 1-.2 2.2c-.3.3-.7.5-1.1.5Zm0-3a1 1 0 0 0-.7.2l-.4.6v.7c0 .3.1.5.3.6.1.2.3.3.6.4h.6l.5-.5a1.3 1.3 0 0 0-.1-1.6c-.2-.2-.5-.4-.8-.4Zm16-59.2h-.2l-.7-.8v-.2a.2.2 0 0 1 0-.2.2.2 0 0 1 .2 0h.1l.7.8v.4h-.2Zm2.2 2.5h-.1l-.7-.8v-.3l.2-.1h.1l.7.8v.3h-.2Zm-2.9 0h-.2v-.2a.3.3 0 0 1 0-.2l.7-.7v-.1a.2.2 0 0 1 .3 0 .3.3 0 0 1 0 .4l-.7.7h-.1Zm2.3-2.5h-.2v-.2a.3.3 0 0 1 0-.2l.7-.8a.2.2 0 0 1 .3 0v.2a.2.2 0 0 1 0 .2l-.7.7h-.1Z"/>
  <path fill="#E6E6E6" d="m91 81.5 3.9-1.2a78 78 0 0 1-1.3-8.7c-2 1.4-4.3 2.2-6.7 2.4l.2.5 4 7Z"/>
  <path fill="#03243B" d="M91 81.7a204.6 204.6 0 0 1-4-7v-.1c-.3-.4-.3-.5-.3-.7h.2a14 14 0 0 0 6.7-2.5h.1v.2a77.7 77.7 0 0 0 1.2 8.9l-3.8 1.2Zm-3.8-7.2 2.7 4.7 1.2 2.1 3.6-1a60 60 0 0 1-1.2-8.5c-2 1.3-4.2 2.1-6.4 2.3l.1.3Z"/>
  <path fill="#FDE692" d="m79.6 70.3-.5-1a11 11 0 0 1 3.4-11.6l.8-.5a9.5 9.5 0 0 1 8.3-.7c5.4 2.3 6.4 10.7 2.3 14.9a9.9 9.9 0 0 1-5 2.4c-1.9.4-4.1.6-6-.2a7.3 7.3 0 0 1-3.3-3.3Z"/>
  <path fill="#03243B" d="M85.9 74.3c-1 0-2-.2-3-.6a7.3 7.3 0 0 1-3.4-3.3l-.5-1c-.7-2-.7-4.2 0-6.5a9.6 9.6 0 0 1 3.5-5.3l.8-.5a9.6 9.6 0 0 1 8.3-.8c1.3.6 2.4 1.5 3.2 2.6a9.7 9.7 0 0 1 1.6 4 10 10 0 0 1-2.4 8.6 10 10 0 0 1-5 2.4c-1 .3-2 .4-3.1.4Zm-6.2-4a7 7 0 0 0 3.2 3.2c1.6.6 3.6.7 6 .1a9.4 9.4 0 0 0 5-2.4c2-2 2.8-5.2 2.2-8.3a8 8 0 0 0-4.5-6.3 9.4 9.4 0 0 0-9 1.2 10 10 0 0 0-3.4 5.2 10 10 0 0 0 .5 7.2Z"/>
  <path fill="#03243B" d="M85.9 74.4c-1 0-2.1-.1-3.1-.5a7.5 7.5 0 0 1-3.4-3.4l-.5-1c-.7-2-.7-4.3 0-6.6.6-2.3 2-4.2 3.5-5.4l.8-.6a9.7 9.7 0 0 1 8.5-.7c1.3.6 2.4 1.5 3.2 2.7a9.8 9.8 0 0 1 1.6 3.9 10 10 0 0 1-2.4 8.8 10.1 10.1 0 0 1-5 2.4c-1.1.3-2.2.4-3.2.4Zm2.4-18.6a10.3 10.3 0 0 0-5.8 1.9 9.7 9.7 0 0 0-3.4 5.2 10.2 10.2 0 0 0 .5 7.4 6.6 6.6 0 0 0 6.3 3.9c1 0 2-.2 3.1-.4a10 10 0 0 0 5-2.4c2-2 2.9-5.3 2.3-8.6a9.5 9.5 0 0 0-1.6-3.8c-.8-1.1-1.8-2-3-2.5a8 8 0 0 0-3.4-.7ZM86 74.1c-1 0-2-.1-3-.5a7.1 7.1 0 0 1-3.3-3.3l-.4-1a10 10 0 0 1 0-6.3 9.6 9.6 0 0 1 3.3-5.2l.9-.6a9.5 9.5 0 0 1 8.2-.7c2.4 1 4.1 3.4 4.6 6.4.6 3.1-.3 6.4-2.3 8.4a9.6 9.6 0 0 1-5 2.4c-1 .3-2 .4-3 .4Zm-6-4a7 7 0 0 0 3 3.2c1.6.7 3.6.8 6 .2a9.4 9.4 0 0 0 4.8-2.3c2-2 2.9-5.2 2.3-8.3a8 8 0 0 0-4.5-6.2 9.3 9.3 0 0 0-8.8 1.3 10 10 0 0 0-3.4 5 9.8 9.8 0 0 0 .5 7.2Z"/>
  <path fill="#03243B" d="M89.5 73.8h-.1a19.3 19.3 0 0 1-4.3-5.4c-.4-.9-.8-2.2-.5-3.5.4-1.3 1.4-2.2 2.5-2.2.3 0 .6 0 .8.2.2-.3.5-.5.9-.6.3 0 .6 0 .8.2.3.1.5.3.7.6.3.5.5 1 .6 1.6.5 2.6.7 5.5.8 8v.2a.2.2 0 0 1 0 .2h-.1a.1.1 0 0 1-.1 0h-.1v-.4a52.9 52.9 0 0 0-1.3-9.5l-.6-.6h-.7c-.2 0-.5.1-.6.3l.6.6c.2.2.3.5.3.8v.8a1 1 0 0 1-1 .8l-.2-.1a.8.8 0 0 1-.3-.2c-.3-.4-.3-1-.3-1.4l.4-1.2-.6-.1c-1 0-1.9.9-2.2 2a5 5 0 0 0 .4 3.2c1 2 2.9 4 4.3 5.3v.4h-.1ZM88 63.2l-.4 1.2c0 .4 0 .8.2 1 0 .2.1.2.2.2h.2c.3.1.5-.2.6-.5a1.5 1.5 0 0 0-.2-1.3 2 2 0 0 0-.6-.6Z"/>
</svg>';
?>
<style>
	#bluehost_help_widget h2 {
	justify-content: start;
	gap: .5rem;
	}
	#bluehost_help_widget h2:before {
	content: url('data:image/svg+xml;base64,<?php echo esc_attr( $svg_64 ); ?>');
	width: 24px;
	height: 24px;
	}
	.helpsvg {
	display: flex;
	justify-content: center;
	align-items: center;
	max-width: 200px;
	min-width: 50%;
	}
	.help-widget {
	display: grid;
	grid-template-columns: 2fr 1fr;
	}
</style>
<div class="nfd-root nfd-widget nfd-widget-help">
	<div class="help-widget">
	<div class="nfd-mt-4 nfd-mb-4">
		<div >
		<p class="nfd-font-bold nfd-mb-4">
			<?php esc_html_e( 'From DIY to full-service help, always by your side.', 'wp-plugin-bluehost' ); ?>
		</p>
		<p>
			<?php esc_html_e( 'Call or chat 24/7 for support or let our experts build your site for you.', 'wp-plugin-bluehost' ); ?><br />
		</p>
		</div>
		<div class="nfd-mt-8">
		<a
			class="nfd-button nfd-button--primary wppbh-help-link nfd-mr-2"
			data-cy="nfd-widget-help-link"
			data-help-center="<?php echo BluehostHelpWidget::can_access_help_center() ? 'true' : 'false'; ?>"
			href="
			<?php
			echo esc_url(
				BluehostAccountWidget::is_jarvis() ?
				BluehostAccountWidget::add_utm_params( BluehostAccountWidget::get_platform_base_url( '/help' ) ) :
				BluehostAccountWidget::add_utm_params( BluehostAccountWidget::get_platform_base_url( '/hosting/help' ) )
			);
			?>
			"
			target="_blank"
			id="nfd-widget-help-link"
		><?php esc_html_e( 'Get Help', 'wp-plugin-bluehost' ); ?></a>
		<a
			class="nfd-button nfd-button--secondary nfd-text-primary wppbh-help-link"
			data-cy="nfd-widget-ctb-link"
			data-action="load-nfd-ctb"
			data-ctb-id="838cc912-adb3-4d75-9450-262bf3ee3576"
			rel="noreferrer"
			href="
			<?php
			echo esc_url( 'https://www.bluehost.com/pro-design-live' );
			?>
			"
			target="_blank"
			id="nfd-widget-hire-our-pros"
		><?php esc_html_e( 'Hire Our Pros', 'wp-plugin-bluehost' ); ?></a>
		</div>
	</div>
	<div class="helpsvg">
		<?php echo wp_kses( $help_svg, KSES_ALLOWED_SVG_TAGS ); ?>
	</div>
	</div>
  
</div>
<?php
	// only add this script if the user has access to the help center
if ( BluehostHelpWidget::can_access_help_center() ) :
	?>
<script>
document.addEventListener( 'DOMContentLoaded', initHelpButtonHandler, false );
function initHelpButtonHandler(){
	const help_button = document.getElementById( 'nfd-widget-help-link' );
	if ( help_button ) {
	help_button.addEventListener( 'click', function( e ) {
		e.preventDefault(); // stop link from opening
		window.newfoldEmbeddedHelp.toggleNFDLaunchedEmbeddedHelp(); // open help center instead
	});
	}
}
</script>
<?php endif; ?>