<?php
session_start();
date_default_timezone_set('Europe/Amsterdam');

// Project check
if (!isset($_POST['project']) || trim($_POST['project']) === '') {
    die("Geen project opgegeven.");
}

$project = trim($_POST['project']);
$start_time = time();

$_SESSION['project'] = $project;
$_SESSION['start_time'] = $start_time;

// Ook opslaan in bestand
$temp_id = md5($_SERVER['REMOTE_ADDR']); // Uniek ID, eventueel vervangen met login-ID
$temp_data = [
    'project' => $project,
    'start_time' => $start_time
];

// Zorg dat map bestaat
if (!is_dir('temp')) {
    mkdir('temp', 0777, true); // Let op bestandsrechten in CPanel
}

file_put_contents("temp/$temp_id.json", json_encode($temp_data));

// Redirect naar uitklokken
header("Location: uitklokken.php");
exit;
