<?php
// Start sessie voor tijdelijke opslag van klokgegevens
session_start();
date_default_timezone_set('Europe/Amsterdam');

// Als er al ingeklokt is, direct naar uitklokken
if (isset($_SESSION['project']) && isset($_SESSION['start_time'])) {
    header("Location: uitklokken.php");
    exit;
}

// Projectenlijst
$projecten = ['BIO-SUDS', 'Other']; // Voeg hier je projecten toe
?>

<!DOCTYPE html>
<html lang="nl">
<head>
    <meta charset="UTF-8">
    <title>Time in</title>
    <link rel="stylesheet" href="assets/style.css">
</head>
<body>

<?php include 'includes/menu.php'; ?>

<h2>Time in</h2>

<form method="post" action="time_in.php">
    <label for="project">Project:</label>
    <select name="project" id="project" required>
        <?php foreach ($projecten as $project): ?>
            <option value="<?= htmlspecialchars($project) ?>"><?= htmlspecialchars($project) ?></option>
        <?php endforeach; ?>
    </select>

    <br><br>
    <button type="submit">Time in</button>
</form>

</body>
</html>
