<?php
// index.php – Instellingen beheer via formulier

$settings_file = __DIR__ . '/settings.php';

// Instellingen laden
$settings = file_exists($settings_file) ? include $settings_file : [
    'accounts' => [],
    'pushover' => ['user_key' => '', 'app_token' => '']
];

// Formulierverwerking
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $settings['accounts'] = [
        'NL' => [
            'client_id' => $_POST['nl_client_id'],
            'client_secret' => $_POST['nl_client_secret'],
        ],
        'BE' => [
            'client_id' => $_POST['be_client_id'],
            'client_secret' => $_POST['be_client_secret'],
        ]
    ];
    $settings['pushover'] = [
        'user_key' => $_POST['pushover_user_key'],
        'app_token' => $_POST['pushover_app_token']
    ];

    // Opslaan naar settings.php
    $export = var_export($settings, true);
    file_put_contents($settings_file, "<?php\n\nreturn {$export};\n");

    $message = "✅ Instellingen succesvol opgeslagen.";
}
?>

<!DOCTYPE html>
<html lang="nl">
<head>
    <meta charset="UTF-8">
    <title>Pushyfy Instellingen</title>
    <style>
        body { font-family: sans-serif; background: #f2f2f2; padding: 2rem; }
        .container { background: white; padding: 2rem; border-radius: 8px; max-width: 700px; margin: auto; box-shadow: 0 0 10px rgba(0,0,0,0.1); }
        input[type="text"], input[type="password"] { width: 100%; padding: 8px; margin: 4px 0 12px; border-radius: 4px; border: 1px solid #ccc; }
        input[type="submit"] { padding: 10px 20px; background: #2a7ae2; color: white; border: none; border-radius: 4px; cursor: pointer; }
        .success { background: #d4edda; padding: 1rem; border: 1px solid #c3e6cb; margin-bottom: 1rem; border-radius: 4px; }
        h2 { margin-top: 2rem; }
    </style>
</head>
<body>
<div class="container">
    <h1>Pushyfy Instellingen</h1>

    <?php if (!empty($message)) : ?>
        <div class="success"><?= htmlspecialchars($message) ?></div>
    <?php endif; ?>

    <form method="post">
        <h2>Bol.com Account NL</h2>
        <label>Client ID</label>
        <input type="text" name="nl_client_id" value="<?= htmlspecialchars($settings['accounts']['NL']['client_id'] ?? '') ?>" required>

        <label>Client Secret</label>
        <input type="password" name="nl_client_secret" value="<?= htmlspecialchars($settings['accounts']['NL']['client_secret'] ?? '') ?>" required>

        <h2>Bol.com Account BE</h2>
        <label>Client ID</label>
        <input type="text" name="be_client_id" value="<?= htmlspecialchars($settings['accounts']['BE']['client_id'] ?? '') ?>" required>

        <label>Client Secret</label>
        <input type="password" name="be_client_secret" value="<?= htmlspecialchars($settings['accounts']['BE']['client_secret'] ?? '') ?>" required>

        <h2>Pushover</h2>
        <label>User Key</label>
        <input type="text" name="pushover_user_key" value="<?= htmlspecialchars($settings['pushover']['user_key'] ?? '') ?>" required>

        <label>App Token</label>
        <input type="text" name="pushover_app_token" value="<?= htmlspecialchars($settings['pushover']['app_token'] ?? '') ?>" required>

        <input type="submit" value="Instellingen opslaan">
    </form>
</div>
</body>
</html>
