<?php
function get_setting($key) {
    $settings = json_decode(file_get_contents('settings.json'), true);
    return $settings[$key] ?? null;
}

function send_pushover($message) {
    $data = [
        'token' => get_setting('pushover_api_key'),
        'user' => get_setting('pushover_user_key'),
        'message' => $message,
        'sound' => get_setting('default_sound')
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, 'https://api.pushover.net/1/messages.json');
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_exec($ch);
    curl_close($ch);
}
