<?php

error_reporting(E_ALL);
ini_set('display_errors', 1);

// Instellingen inladen vanuit extern bestand
$settings = require __DIR__ . '/settings.php';

$accounts = $settings['accounts'];
$pushover_user_key = $settings['pushover']['user_key'];
$pushover_app_token = $settings['pushover']['app_token'];
$melding_settings = $settings['melding'] ?? [];
$melding_titel = $melding_settings['titel'] ?? 'Nieuwe Bol.com bestelling';
$geluid_drempels = $melding_settings['geluid_drempels'] ?? [];

/**
 * Verwerk Bol.com bestellingen en stuur pushmelding via Pushover.
 */
function verwerk_bestellingen($client_id, $client_secret, $user_key, $app_token, $label, $melding_titel, $geluid_drempels)
 {
    $order_id_file = __DIR__ . "/last_bol_order_time_{$label}.txt";

    // Access token ophalen
    $ch = curl_init("https://login.bol.com/token");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, "grant_type=client_credentials");
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Content-Type: application/x-www-form-urlencoded",
        "Authorization: Basic " . base64_encode("$client_id:$client_secret")
    ]);
    $token_response = curl_exec($ch);
    curl_close($ch);

    $token_data = json_decode($token_response, true);
    $access_token = $token_data['access_token'] ?? null;

    if (!$access_token) {
        echo "❌ Geen access token voor account: $label<br>";
        return;
    }

    // Laatste verwerkte order tijd ophalen
    $last_order_time = file_exists($order_id_file) ? trim(file_get_contents($order_id_file)) : '';

    // Openstaande orders ophalen
    $ch = curl_init("https://api.bol.com/retailer/orders?status=OPEN");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Accept: application/vnd.retailer.v9+json",
        "Authorization: Bearer $access_token"
    ]);
    $orders_response = curl_exec($ch);
    curl_close($ch);

    $orders_data = json_decode($orders_response, true);

    if (empty($orders_data['orders'])) {
        echo "ℹ️ Geen openstaande orders voor account: $label<br>";
        return;
    }

    // Nieuwste order bepalen
    $newest_order = null;
    foreach ($orders_data['orders'] as $order) {
        if (is_null($newest_order) || $order['orderPlacedDateTime'] > $newest_order['orderPlacedDateTime']) {
            $newest_order = $order;
        }
    }

    if (is_null($newest_order)) {
        echo "ℹ️ Geen nieuwste order gevonden voor account: $label<br>";
        return;
    }

    $new_order_time = $newest_order['orderPlacedDateTime'];
    $new_order_id = $newest_order['orderId'];

    if ($new_order_time !== $last_order_time) {
        // Orderdetails ophalen
        $ch = curl_init("https://api.bol.com/retailer/orders/$new_order_id");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            "Accept: application/vnd.retailer.v9+json",
            "Authorization: Bearer $access_token"
        ]);
        $details_response = curl_exec($ch);
        curl_close($ch);

        $details_data = json_decode($details_response, true);

        $total_price = 0.0;
        $product_list = "";
        if (isset($details_data['orderItems'])) {
            foreach ($details_data['orderItems'] as $item) {
                $unit_price = $item['unitPrice'] ?? 0;
                $quantity = $item['quantity'] ?? 1;
                $product_title = 'Onbekend product';
                if (!empty($item['orderItemTitle'])) {
                    $product_title = htmlspecialchars($item['orderItemTitle']);
                } elseif (!empty($item['ean'])) {
                    $product_title = 'Product met EAN: ' . htmlspecialchars($item['ean']);
                }
                $total_price += ($unit_price * $quantity);
                $product_list .= "- {$quantity}x {$product_title}\n";
            }
        }

  // Dynamisch geluid op basis van ingestelde drempels
$sound = 'pushover'; // fallback
foreach ($geluid_drempels as $drempel) {
    if ($total_price < $drempel['bedrag']) {
        $sound = $drempel['sound'];
        break;
    }
}


        // Pushbericht voorbereiden
        $kort_bericht = "Order ID: $new_order_id\nTotaal: €" . number_format($total_price, 2, ',', '.');

        $volledig_bericht = "<b>Order ID:</b> $new_order_id<br>" .
                             "<b>Bestelwaarde:</b> €" . number_format($total_price, 2, ',', '.') . "<br><br>" .
                             "<b>Bestelde producten:</b><br>" .
                             nl2br($product_list);

        $post_fields = [
            'token' => $app_token,
            'user' => $user_key,
            'title' => "{$melding_titel} ($label)! 📦",
            'message' => $kort_bericht,
            'priority' => 1,
            'sound' => $sound,
            'html' => 1,
            'url' => "data:text/html," . urlencode($volledig_bericht),
            'url_title' => "Bekijk bestelling details"
        ];

        $ch = curl_init("https://api.pushover.net/1/messages.json");
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_fields));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_exec($ch);
        curl_close($ch);

        // Laatste order tijd opslaan
        file_put_contents($order_id_file, $new_order_time);

        echo "✅ Nieuwe Bol.com order gemeld voor account: $label<br>";
    } else {
        echo "ℹ️ Geen nieuwe orders sinds laatste check voor account: $label<br>";
    }
}

// Alle accounts uit instellingen verwerken
foreach ($accounts as $label => $credentials) {
    verwerk_bestellingen(
        $credentials['client_id'],
        $credentials['client_secret'],
        $pushover_user_key,
        $pushover_app_token,
        $label,
        $melding_titel,
        $geluid_drempels
    );
}

?>
