<?php

error_reporting(E_ALL);
ini_set('display_errors', 1);

// API gegevens Account 1
$client_id_1 = 'efce126e-4fd3-4ceb-8fc8-72aa339d4715';
$client_secret_1 = 'f0kP?aa65xjiSP0Tv8H0G9M3?ReBTOrq3zkJZ3!wfA8MbR(TLhHrtkgi7ziOCZbe';

// API gegevens Account 2
$client_id_2 = '10dca002-f819-4d48-b32b-628bd5f75bdb';
$client_secret_2 = 'nazkRHB)mYesQ2PTHix2Az4PouXuGqts+@NRCxtX6IwVI21BYeRI5DTvJcJIv+n)';

// Pushover gegevens
$user_key = 'uw4bjs1vius7n536p8ovc2n44ngzd6';
$app_token = 'ay93qc8ejm9d2x3b8makni9jir82c9';

// Functie om bestellingen van één account te verwerken
function verwerk_bestellingen($client_id, $client_secret, $user_key, $app_token, $label) {
    $order_id_file = __DIR__ . "/last_bol_order_time_{$label}.txt";

    // Token ophalen
    $ch = curl_init("https://login.bol.com/token");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, "grant_type=client_credentials");
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Content-Type: application/x-www-form-urlencoded",
        "Authorization: Basic " . base64_encode("$client_id:$client_secret")
    ]);
    $token_response = curl_exec($ch);
    curl_close($ch);

    $token_data = json_decode($token_response, true);
    $access_token = $token_data['access_token'] ?? null;

    if (!$access_token) {
        echo "❌ Geen access token voor account: $label<br>";
        return;
    }

    // Laatst verwerkte order tijd laden
    $last_order_time = file_exists($order_id_file) ? trim(file_get_contents($order_id_file)) : '';

    // Nieuwe bestellingen ophalen
    $ch = curl_init("https://api.bol.com/retailer/orders?status=OPEN");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Accept: application/vnd.retailer.v9+json",
        "Authorization: Bearer $access_token"
    ]);
    $orders_response = curl_exec($ch);
    curl_close($ch);

    $orders_data = json_decode($orders_response, true);

    if (!isset($orders_data['orders']) || empty($orders_data['orders'])) {
        echo "ℹ️ Geen openstaande orders voor account: $label<br>";
        return;
    }

    // Nieuwste order zoeken
    $newest_order = null;
    foreach ($orders_data['orders'] as $order) {
        if (is_null($newest_order) || $order['orderPlacedDateTime'] > $newest_order['orderPlacedDateTime']) {
            $newest_order = $order;
        }
    }

    if (is_null($newest_order)) {
        echo "ℹ️ Geen nieuwste order gevonden voor account: $label<br>";
        return;
    }

    $new_order_time = $newest_order['orderPlacedDateTime'];
    $new_order_id = $newest_order['orderId'];

    if ($new_order_time !== $last_order_time) {
        // Extra orderdetails ophalen
        $ch = curl_init("https://api.bol.com/retailer/orders/$new_order_id");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            "Accept: application/vnd.retailer.v9+json",
            "Authorization: Bearer $access_token"
        ]);
        $details_response = curl_exec($ch);
        curl_close($ch);

        $details_data = json_decode($details_response, true);

        $total_price = 0.0;
        $product_list = "";
        if (isset($details_data['orderItems'])) {
            foreach ($details_data['orderItems'] as $item) {
                $unit_price = $item['unitPrice'] ?? 0;
                $quantity = $item['quantity'] ?? 1;
                $product_title = 'Onbekend product';
                if (!empty($item['orderItemTitle'])) {
                    $product_title = htmlspecialchars($item['orderItemTitle']);
                } elseif (!empty($item['ean'])) {
                    $product_title = 'Product met EAN: ' . htmlspecialchars($item['ean']);
                }
                $total_price += ($unit_price * $quantity);
                $product_list .= "- {$quantity}x {$product_title}\n";
            }
        }

        // Geluid bepalen op basis van totaalbedrag
        if ($total_price < 7) {
            $sound = 'cashregister';
        } elseif ($total_price < 20) {
            $sound = 'bike';
        } elseif ($total_price < 50) {
            $sound = 'magic';
        } else {
            $sound = 'siren';
        }

        // Kort bericht voor snelle melding
        $kort_bericht = "Order ID: $new_order_id\nTotaal: €" . number_format($total_price, 2, ',', '.');

        // Volledige bericht bij openen
        $volledig_bericht = "<b>Order ID:</b> $new_order_id<br>" .
                             "<b>Bestelwaarde:</b> €" . number_format($total_price, 2, ',', '.') . "<br><br>" .
                             "<b>Bestelde producten:</b><br>" .
                             nl2br($product_list);

        // Pushmelding sturen
        $post_fields = [
            'token' => $app_token,
            'user' => $user_key,
            'title' => "Nieuwe Bol.com bestelling ($label)! 📦",
            'message' => $kort_bericht,
            'priority' => 1,
            'sound' => $sound,
            'html' => 1,
            'url' => "data:text/html," . urlencode($volledig_bericht),
            'url_title' => "Bekijk bestelling details"
        ];

        $ch = curl_init("https://api.pushover.net/1/messages.json");
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_fields));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_exec($ch);
        curl_close($ch);

        // Laatste order tijd opslaan
        file_put_contents($order_id_file, $new_order_time);

        echo "✅ Nieuwe Bol.com order gemeld voor account: $label<br>";
    } else {
        echo "ℹ️ Geen nieuwe orders sinds laatste check voor account: $label<br>";
    }
}

// Beide accounts verwerken
verwerk_bestellingen($client_id_1, $client_secret_1, $user_key, $app_token, "NL");
verwerk_bestellingen($client_id_2, $client_secret_2, $user_key, $app_token, "BE");

?>
