<?php
session_start();
if (!isset($_SESSION['ingelogd'])) {
    header('Location: ../login.php');
    exit;
}

$tasksFile = 'data/tasks.json';
$companiesFile = 'data/companies.json';

$tasks = file_exists($tasksFile) ? json_decode(file_get_contents($tasksFile), true) : [];
$companies = file_exists($companiesFile) ? json_decode(file_get_contents($companiesFile), true) : [];

// Filter op 'Open' + vandaag
$todos = array_filter($tasks, function ($t) {
    return isset($t['status'], $t['vervaldatum']) &&
           $t['status'] === 'Open' &&
           date('Y-m-d', strtotime($t['vervaldatum'])) === date('Y-m-d');
});

// ✅ Omzet samenvatten per maand (status = Betaald)
$maandOmzet = [];
foreach ($companies as $bedrijf) {
    if (!isset($bedrijf['omzetregels']) || !is_array($bedrijf['omzetregels'])) continue;

    foreach ($bedrijf['omzetregels'] as $regel) {
        if (($regel['status'] ?? '') !== 'Betaald') continue;
        if (empty($regel['datum']) || strtotime($regel['datum']) === false) continue;

        $maand = date('Y-m', strtotime($regel['datum']));
        $bedrag = floatval($regel['bedrag'] ?? 0);
        $maandOmzet[$maand] = ($maandOmzet[$maand] ?? 0) + $bedrag;
    }
}
krsort($maandOmzet); // Laatste maand eerst
?>

<!DOCTYPE html>
<html lang="nl">
<head>
    <meta charset="UTF-8">
    <title>Bio-Suds CRM</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" type="image/png" href="/crm/favicon.png">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<?php include 'includes/menu.php'; ?>
<div class="container py-4 px-3">
    <h1 class="mb-4 text-center text-md-start">👋 Welkom bij <strong>Bio-Suds CRM</strong></h1>

    <div class="row gy-4">
        <!-- 📌 To-do vandaag -->
        <div class="col-md-6">
            <div class="card h-100 shadow-sm">
                <div class="card-header bg-primary text-white">
                    📌 To-do vandaag (<?= count($todos) ?>)
                </div>
                <ul class="list-group list-group-flush">
                    <?php if (empty($todos)): ?>
                        <li class="list-group-item text-muted">Geen taken vandaag 🎉</li>
                    <?php else: ?>
                        <?php foreach ($todos as $id => $todo): ?>
                            <li class="list-group-item d-flex justify-content-between align-items-center flex-wrap">
                                <span><?= htmlspecialchars($todo['titel']) ?></span>
                                <a href="tasks/bewerken.php?id=<?= urlencode($id) ?>" class="btn btn-sm btn-outline-primary mt-2 mt-md-0">Bekijk</a>
                            </li>
                        <?php endforeach ?>
                    <?php endif; ?>
                </ul>
            </div>
        </div>

       <!-- 📊 Laatste omzet -->
<div class="col-md-6">
    <div class="card h-100 shadow-sm">
        <div class="card-header bg-success text-white">
            💶 Laatste omzet per maand
        </div>
        <ul class="list-group list-group-flush">
            <?php
            $maanden = [
                '01' => 'januari', '02' => 'februari', '03' => 'maart', '04' => 'april',
                '05' => 'mei', '06' => 'juni', '07' => 'juli', '08' => 'augustus',
                '09' => 'september', '10' => 'oktober', '11' => 'november', '12' => 'december'
            ];
            if (empty($maandOmzet)): ?>
                <li class="list-group-item text-muted">Nog geen betaalde omzet beschikbaar.</li>
            <?php else: ?>
                <?php foreach (array_slice($maandOmzet, 0, 6) as $maand => $bedrag): ?>
                    <?php
                    $parts = explode('-', $maand);
                    $label = $maanden[$parts[1]] . ' ' . $parts[0];
                    ?>
                    <li class="list-group-item d-flex justify-content-between">
                        <?= $label ?>
                        <strong>€ <?= number_format($bedrag, 2, ',', '.') ?></strong>
                    </li>
                <?php endforeach ?>
            <?php endif; ?>
        </ul>
        <div class="card-footer text-end">
            <a href="/crm/omzet/index.php">📁 Bekijk alle</a>
        </div>
    </div>
</div>

        <!-- 🚀 Snelkoppelingen -->
        <div class="col-md-6">
            <div class="card shadow-sm">
                <div class="card-header bg-dark text-white">
                    🚀 Snelkoppelingen
                </div>
                <div class="list-group list-group-flush">
                    <a href="contacts/index.php" class="list-group-item list-group-item-action">👤 Contactpersonen</a>
                    <a href="companies/index.php" class="list-group-item list-group-item-action">🏢 Bedrijven</a>
                    <a href="deals/index.php" class="list-group-item list-group-item-action">📄 Deals</a>
                    <a href="tasks/index.php" class="list-group-item list-group-item-action">✅ Taken</a>
                </div>
            </div>
        </div>

        <!-- 💡 Tip -->
        <div class="col-md-6">
            <div class="card shadow-sm">
                <div class="card-body">
                    <h5 class="card-title">💡 Tip van de dag</h5>
                    <p class="card-text">
                        Bekijk nu ook omzet per maand op dit dashboard! Zorg dat je omzetregels toevoegt bij bedrijven met status "Betaald".
                    </p>
                </div>
            </div>
        </div>
    </div>
</div>
</body>
</html>
