<?php
$dealsFile = '../data/deals.json';
$contactsFile = '../data/contacts.json';
$companiesFile = '../data/companies.json';

$deals = file_exists($dealsFile) ? json_decode(file_get_contents($dealsFile), true) : [];
$contacts = file_exists($contactsFile) ? json_decode(file_get_contents($contactsFile), true) : [];
$companies = file_exists($companiesFile) ? json_decode(file_get_contents($companiesFile), true) : [];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = uniqid();
    $opmerking = trim($_POST['opmerkingen'] ?? '');

    $deals[$id] = [
        'naam' => $_POST['naam'],
        'stadium' => $_POST['stadium'],
        'type' => $_POST['type'],
        'jaartal' => $_POST['jaartal'],
        'sluitingsdatum' => $_POST['sluitingsdatum'],
        'bedrag' => $_POST['bedrag'],
        'barter' => $_POST['barter'],
        'barter_type' => $_POST['barter_type'] ?? '',
        'barter_omschrijving' => $_POST['barter_omschrijving'] ?? '',
        'barter_bedrag' => $_POST['barter_bedrag'] ?? '',
        'contact_id' => $_POST['contact_id'] ?? '',
        'company_id' => $_POST['company_id'] ?? '',
        'opmerkingen' => $opmerking
    ];

    // Optionele debugregel (verwijderen als het werkt)
    // file_put_contents('debug_post.txt', print_r($_POST, true));

    file_put_contents($dealsFile, json_encode($deals, JSON_PRETTY_PRINT));
    header('Location: index.php');
    exit;
}
?>

<!DOCTYPE html>
<html lang="nl">
<head>
    <meta charset="UTF-8">
    <title>Nieuwe Deal</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <script>
        function toggleBarterDetails() {
            const isBarter = document.querySelector('select[name="barter"]').value === 'ja';
            document.getElementById('barter-details').style.display = isBarter ? 'block' : 'none';
        }
    </script>
</head>
<body class="bg-light" onload="toggleBarterDetails()">
<?php include '../includes/menu.php'; ?>
<div class="container py-5">
    <h2 class="mb-4">Nieuwe Deal</h2>
    <form method="post">
        <div class="mb-3"><input type="text" name="naam" class="form-control" placeholder="Naam deal" required></div>

        <div class="mb-3">
            <select name="stadium" class="form-control" required>
                <option value="">Stadium</option>
                <option>Suspect - contact gegevens zijn bekend</option>
                <option>Lead - eerste contact</option>
                <option>Prospect - proefpakket verstuurd</option>
                <option>Hot Prospect - toesturen offerte</option>
                <option>Relatie - Toesturen factuur</option>
                <option>Relatie - Gesloten, gewonnen</option>
                <option>Relatie - Gesloten, verloren</option>
                <option>Relatie - Postponed</option>
            </select>
        </div>

        <div class="mb-3">
            <select name="type" class="form-control">
                <option value="">Type Deal</option>
                <option>Ambassadeur</option>
                <option>B&B</option>
                <option>Kapperszaak</option>
                <option>Kledingzaak</option>
                <option>Restaurant</option>
                <option>Hotel</option>
                <option>Voetbal</option>
                <option>Overig</option>
            </select>
        </div>

        <div class="mb-3"><input type="number" name="jaartal" class="form-control" placeholder="Jaartal (bijv. 2025)"></div>
        <div class="mb-3"><input type="date" name="sluitingsdatum" class="form-control" required></div>
        <div class="mb-3"><input type="number" step="0.01" name="bedrag" class="form-control" placeholder="Bedrag in euro's"></div>

        <div class="mb-3">
            <label>Barter?</label>
            <select name="barter" class="form-control" onchange="toggleBarterDetails()">
                <option value="nee">Nee</option>
                <option value="ja">Ja</option>
            </select>
        </div>

        <div id="barter-details" style="display:none;">
            <div class="mb-3"><input type="text" name="barter_type" class="form-control" placeholder="Type barter (bijv. product, dienst)"></div>
            <div class="mb-3"><textarea name="barter_omschrijving" class="form-control" placeholder="Omschrijving barter"></textarea></div>
            <div class="mb-3"><input type="number" step="0.01" name="barter_bedrag" class="form-control" placeholder="Barterwaarde in euro's"></div>
        </div>

        <div class="mb-3">
            <label>Koppel aan contactpersoon:</label>
            <select name="contact_id" class="form-control">
                <option value="">— Geen —</option>
                <?php foreach ($contacts as $id => $c): ?>
                    <option value="<?= $id ?>"><?= htmlspecialchars($c['naam']) ?></option>
                <?php endforeach ?>
            </select>
        </div>

        <div class="mb-3">
            <label>Koppel aan bedrijf:</label>
            <select name="company_id" class="form-control">
                <option value="">— Geen —</option>
                <?php foreach ($companies as $id => $co): ?>
                    <option value="<?= $id ?>"><?= htmlspecialchars($co['naam']) ?></option>
                <?php endforeach ?>
            </select>
        </div>

        <div class="mb-3">
            <label for="opmerkingen" class="form-label">Opmerkingen / Notities</label>
            <textarea name="opmerkingen" id="opmerkingen" class="form-control" rows="4" placeholder="Bijv. wat er besproken is, wat er nog moet gebeuren..."></textarea>
        </div>

        <button type="submit" class="btn btn-success">Opslaan</button>
    </form>
</div>
</body>
</html>
