<?php
session_start();
if (!isset($_SESSION['ingelogd'])) {
    header('Location: ../login.php');
    exit;
}

$contactsFile = '../data/contacts.json';
$contacts = file_exists($contactsFile) ? json_decode(file_get_contents($contactsFile), true) : [];

$id = $_GET['id'] ?? '';
if (!isset($contacts[$id])) {
    die('Contactpersoon niet gevonden.');
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && $_POST['bevestig'] === 'ja') {
    unset($contacts[$id]);
    file_put_contents($contactsFile, json_encode($contacts, JSON_PRETTY_PRINT));
    header('Location: index.php');
    exit;
}

$persoon = $contacts[$id];
?>

<!DOCTYPE html>
<html lang="nl">
<head>
    <meta charset="UTF-8">
    <title>Contactpersoon verwijderen</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<?php include '../includes/menu.php'; ?>
<div class="container py-5">
    <h2 class="mb-4 text-danger">Contactpersoon verwijderen</h2>
    <p>Weet je zeker dat je <strong><?= htmlspecialchars($persoon['naam']) ?></strong> wilt verwijderen?</p>

    <form method="post">
        <input type="hidden" name="bevestig" value="ja">
        <button type="submit" class="btn btn-danger">Ja, verwijderen</button>
        <a href="index.php" class="btn btn-secondary">Annuleren</a>
    </form>
</div>
</body>
</html>
