<?php
session_start();
if (!isset($_SESSION['ingelogd'])) {
    header('Location: ../login.php');
    exit;
}

$companiesFile = '../data/companies.json';
$companies = file_exists($companiesFile) ? json_decode(file_get_contents($companiesFile), true) : [];

$id = $_GET['id'] ?? '';
if (!isset($companies[$id])) {
    die('Bedrijf niet gevonden.');
}

// Verwijder als bevestigd
if ($_SERVER['REQUEST_METHOD'] === 'POST' && $_POST['bevestig'] === 'ja') {
    unset($companies[$id]);
    file_put_contents($companiesFile, json_encode($companies, JSON_PRETTY_PRINT));
    header('Location: index.php');
    exit;
}

$bedrijf = $companies[$id];
?>

<!DOCTYPE html>
<html lang="nl">
<head>
    <meta charset="UTF-8">
    <title>Bedrijf verwijderen</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<?php include '../includes/menu.php'; ?>
<div class="container py-5">
    <h2 class="mb-4 text-danger">Bedrijf verwijderen</h2>
    <p>Weet je zeker dat je het bedrijf <strong><?= htmlspecialchars($bedrijf['naam']) ?></strong> wilt verwijderen?</p>

    <form method="post">
        <input type="hidden" name="bevestig" value="ja">
        <button type="submit" class="btn btn-danger">Ja, verwijderen</button>
        <a href="index.php" class="btn btn-secondary">Annuleren</a>
    </form>
</div>
</body>
</html>
