<?php
session_start();
require_once 'config.php';

if (!$_SESSION['logged_in']) die("Niet ingelogd.");

// Ophalen van originele mailgegevens
$mailboxLabel = $_GET['mailbox'] ?? '';
$uid = (int)($_GET['uid'] ?? 0);

if (!isset($mailboxes[$mailboxLabel])) die("Mailbox ongeldig");

$box = $mailboxes[$mailboxLabel];
$imap = imap_open(
    "{" . $box['imap_host'] . ":" . $box['imap_port'] . "/imap/ssl}INBOX",
    $box['username'],
    $box['password']
) or die("IMAP-fout: " . imap_last_error());

$overview = imap_fetch_overview($imap, $uid, FT_UID)[0];
$body = imap_fetchbody($imap, $uid, 1, FT_UID);
imap_close($imap);

$replyTo = $overview->from;
$subject = "Re: " . ($overview->subject ?? '(geen onderwerp)');
$quotedBody = "\n\n--------------------\n" . $body;

?>
<!DOCTYPE html>
<html>
<head>
    <title>Beantwoorden</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
<a href="dashboard.php">← Terug</a>
<h2>Beantwoorden aan <?= htmlspecialchars($replyTo) ?></h2>
<form method="post" action="send.php" enctype="multipart/form-data">
    <input type="hidden" name="reply_mode" value="1">
    <input type="hidden" name="to" value="<?= htmlspecialchars($replyTo) ?>">

    <label>Van:</label>
    <select name="from" required>
        <?php foreach ($mailboxes as $email => $_): ?>
            <option value="<?= $email ?>" <?= $email == $box['username'] ? 'selected' : '' ?>><?= $email ?></option>
        <?php endforeach; ?>
    </select><br>

    <label>Onderwerp:</label>
    <input type="text" name="subject" value="<?= htmlspecialchars($subject) ?>" required><br>

    <label>Bericht:</label>
    <textarea name="message" rows="10" required><?= htmlspecialchars($quotedBody) ?></textarea><br>

    <label>Bijlage (optioneel):</label>
    <input type="file" name="attachment"><br>

    <button type="submit">📤 Verzenden</button>
</form>
</body>
</html>
